/*************************************************************************************/
/* Pprava situace																	 */
/*************************************************************************************/
DROP DATABASE OrderByDemo
CREATE DATABASE OrderByDemo
USE OrderByDemo


-- Primitivn tabulka s clusterovanm primrnm klem
CREATE TABLE Data
(
	RecordID int IDENTITY(1,1) NOT NULL,
	VlastnikID int NOT NULL,
	CONSTRAINT PK_Data PRIMARY KEY CLUSTERED (RecordID ASC) 
) ON [PRIMARY]
GO


-- Vlome vzorov data
INSERT INTO Data(VlastnikID) VALUES(5)
INSERT INTO Data(VlastnikID) VALUES(4)
INSERT INTO Data(VlastnikID) VALUES(50)
INSERT INTO Data(VlastnikID) VALUES(27)
INSERT INTO Data(VlastnikID) VALUES(1)
INSERT INTO Data(VlastnikID) VALUES(18)
INSERT INTO Data(VlastnikID) VALUES(3)
GO

/*************************************************************************************/
/* Parametrizace ORDER BY															 */
/*************************************************************************************/
DECLARE @OrderSwitch int
SET @OrderSwitch = 1

SELECT * FROM Data ORDER BY (CASE @OrderSwitch
								WHEN 1 THEN VlastnikID
								ELSE RecordID
							END)
GO

-- Bude se liit execution plan?
SELECT * FROM Data ORDER BY RecordID
GO

-- Bude se liit execution plan?
SELECT * FROM Data ORDER BY VlastnikID
GO



